<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Toubiz map node view helper.
 *
 * Returns the document/page node that contains a toubiz map.
 */
class ToubizMapNodeViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * This may also return null in case no page contains a toubiz map.
     *
     * @return Node|null
     */
    public function render()
    {
        $node = $this->controllerContext->getRequest()->getInternalArgument('__node');
        $site = $node->getContext()->getCurrentSiteNode();

        $query = new FlowQuery([$site]);
        return $query->find('[instanceof Newland.Toubiz.Map.Neos:Map]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }
}
