<?php

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\Toubiz\Poi\Neos\Service;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\Exception\InvalidConfigurationException;

class RegionService
{
    /**
     * @var array
     * @Flow\InjectConfiguration(path="regions.available")
     */
    protected $regionsAvailable;

    /**
     * @var array
     */
    private $zips = [];

    /**
     * @var array
     */
    private $regionsParsed = [];

    public function getZipsFromRegionKeys(array $regionsEnabled): array
    {
        $this->collectZipsFromRegionKeys($regionsEnabled);

        return $this->zips;
    }

    /**
     * @param array $regionKeys
     * @throws InvalidConfigurationException
     */
    private function collectZipsFromRegionKeys(array $regionKeys)
    {
        $regions = $this->getConcreteConfigForRegions($regionKeys);

        foreach ($regions as $region) {
            // validate configuration
            if (!is_array($region) || !array_key_exists('contains', $region)) {
                throw new InvalidConfigurationException('Region is not configured.', 1551107299);
            }

            // avoid loops
            if (array_key_exists($region['name'], $this->regionsParsed)) {
                continue;
            }
            $this->regionsParsed[$region['name']] = true;

            // get zips recursively
            if ($region['contains'] === 'zips') {
                $this->zips = array_merge($this->zips, $region['children']);
            } elseif ($region['contains'] === 'regions') {
                $this->collectZipsFromRegionKeys($region['children']);
            }
        }
    }

    private function getConcreteConfigForRegions(array $regionKeys)
    {
        $regions = [];

        foreach ($regionKeys as $regionKey) {
            if (array_key_exists($regionKey, $this->regionsAvailable)) {
                $regions[$regionKey] = $this->regionsAvailable[$regionKey];
            }
        }

        return $regions;
    }
}
