<?php
namespace Newland\Toubiz\Poi\Neos\Domain\Model;

use Neos\Utility\Arrays;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

class Topic
{
    const TYPE_CATEGORY = 'category';
    const TYPE_ATTRIBUTE = 'attribute';

    /** @var string */
    private $title;

    /** @var string */
    private $type;

    /** @var string */
    private $identifier;

    /** @var string */
    private $combinedIdentifier;

    /** @var mixed */
    private $value;

    /** @var iterable */
    private $articles;

    /** @var \Closure */
    private $articleGetter;

    /** @var int */
    private $totalCount;

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): Topic
    {
        $this->title = $title;
        return $this;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier): Topic
    {
        $this->identifier = $identifier;
        return $this;
    }

    public function getCombinedIdentifier(): string
    {
        return $this->combinedIdentifier;
    }

    public function setCombinedIdentifier(string $combinedIdentifier): Topic
    {
        $this->combinedIdentifier = $combinedIdentifier;
        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): Topic
    {
        $this->type = $type;
        return $this;
    }

    public function getValue()
    {
        return $this->value;
    }

    public function setValue($value): Topic
    {
        $this->value = $value;
        return $this;
    }

    public function getArticles(): iterable
    {
        if (!$this->articles && $this->articleGetter) {
            $this->articles = \call_user_func($this->articleGetter);
        }
        return $this->articles;
    }

    public function setArticleGetter(\Closure $getter): Topic
    {
        $this->articleGetter = $getter;
        return $this;
    }

    public function setArticles(iterable $articles): Topic
    {
        $this->articles = $articles;
        return $this;
    }

    public function getTotalCount(): int
    {
        return $this->totalCount;
    }

    public function setTotalCount(int $totalCount): Topic
    {
        $this->totalCount = $totalCount;
        return $this;
    }
}
