<?php
namespace Newland\Toubiz\Poi\Neos\DataSource;

use Neos\Flow\Annotations as Flow;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Configuration\Exception\InvalidConfigurationException;
use Neos\Neos\Service\DataSource\AbstractDataSource;

/**
 * @Flow\Scope("singleton")
 */
class RegionsDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-poi-neos-regions';

    /**
     * @Flow\InjectConfiguration(path="regions.available")
     */
    protected $regionsAvailable;
    /**
     * @Flow\InjectConfiguration(path="regions.enabled")
     */
    protected $regionsEnabled;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        $this->regionsAvailable = (array) $this->regionsAvailable;
        $this->regionsEnabled = (array) $this->regionsEnabled;

        $regions = [];

        foreach ($this->regionsEnabled as $region) {
            if (!array_key_exists($region, $this->regionsAvailable)) {
                throw new InvalidConfigurationException('Region is not configured.', 1551114278);
            }

            $regions[] = [
                'value' => $region,
                'label' => $this->regionsAvailable[$region]['name'],
            ];
        }

        return $regions;
    }
}
