<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Collection\Attributes;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;

class BestSeasonViewHelper extends AbstractViewHelper
{
    /**
     * @var array
     */
    protected static $months = [ 'jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec' ];

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('attributes', Collection::class, 'Attributes on the article', true);
    }

    public function render(): array
    {
        /** @var Collection<int, Attribute> $attributes */
        $attributes = $this->arguments['attributes'];

        $values = $attributes
            ->filter(function (Attribute $attribute) {
                return $attribute->getName() === 'bestSeason';
            })->map(function (Attribute $attribute) {
                return $attribute->getData();
            });

        $bestSeason = [];
        foreach (static::$months as $month) {
            $bestSeason[$month] = $values->contains($month);
        }
        return $bestSeason;
    }
}
