<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\EntityList;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\Toubiz\Poi\Neos\ViewHelpers\EntityList\Controller\ArticlesController;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists\ArticleList;

class ArticlesViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var ArticlesController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('node', NodeInterface::class, 'A node.', true);
        $this->registerArgument('articleList', ArticleList::class, 'The article list.');
        $this->registerArgument('article', Article::class, 'The article the entity list is connected to.');
        $this->registerArgument('limit', 'integer', 'Query override for additional filtering.', false, 11);
    }

    public function render(): string
    {
        $response = $this->initiateSubRequest();
        return (string) $response->getBody();
    }
}
