<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Teaser;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class TourTeaserTest extends TeaserTestCase
{

    protected function articleType(): int
    {
        return ArticleConstants::TYPE_TOUR;
    }

    public function testDisplaysStarClassificationOnTeaser(): void
    {
        $article = $this->article([ 'starClassifications' => [
            $this->starClassificationFactory->create([ 'value' => 3 ])
        ]]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseContains('<div class="tb-rating mb-2">', $response);
    }

    public function testDoesNotDisplayUnknownStarClassificationOnTeaser(): void
    {
        $article = $this->article([ 'starClassifications' => [
            $this->starClassificationFactory->create([ 'value' => -1 ])
        ]]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseNotContains('<div class="tb-rating mb-2">', $response);
    }

    public function testDisplaysDurationOfTour(): void
    {
        $article = $this->article([ 'attributes' => [
            $this->attributeFactory->create([ 'name' => 'tourDuration', 'data' => 92 ])
        ] ]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseContains('xlink:href="#icon-duration"', $response);
        $this->assertResponseContains('01:32 h', $response);
    }

    public function testDoesNotDisplayDurationIfNoDurationExists(): void
    {
        $article = $this->article([ ]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseNotContains('xlink:href="#icon-duration"', $response);
    }

    public function testDoesNotDisplayDurationIfNoDurationIsZero(): void
    {
        $article = $this->article([ 'attributes' => [
            $this->attributeFactory->create([ 'name' => 'tourDuration', 'data' => 0 ])
        ] ]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseNotContains('xlink:href="#icon-duration"', $response);
    }


    public function testDisplaysAscentElevationOfTour(): void
    {
        $article = $this->article([ 'attributes' => [
            $this->attributeFactory->create([ 'name' => 'ascentElevation', 'data' => 92 ])
        ] ]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseContains('xlink:href="#icon-ascend"', $response);
        $this->assertResponseContains('92 m', $response);
    }

    public function testDoesNotDisplayAscentElevationIfNoDurationExists(): void
    {
        $article = $this->article([ ]);

        $this->node->setProperty('ascentElevation', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseNotContains('xlink:href="#icon-ascend"', $response);
    }

    public function testDoesNotDisplayAscentElevationIfNoDurationIsZero(): void
    {
        $article = $this->article([ 'attributes' => [
            $this->attributeFactory->create([ 'name' => 'ascentElevation', 'data' => 0 ])
        ] ]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseNotContains('xlink:href="#icon-ascend"', $response);
    }
}
