<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Teaser;

use Newland\NeosTestingHelpers\CompilesFusion;
use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;

class StandaloneTeaserTest extends IntegrationTestCase
{
    use CompilesFusion;

    public function testTeaserCanBeRenderedStandalone(): void
    {
        $name = uniqid('ARTICLE_TITLE_', true);
        $article = $this->articleFactory->create([ 'name' => $name ]);

        $result = $this->compileFusion(
            $this->siteNode,
            sprintf('Newland.Toubiz.Poi.Neos:Teaser {
                    properties = Neos.Fusion:DataStructure {
                        article = "%s"
                    }
                }', $article->getPersistenceObjectIdentifier()),
            [ 'documentNode' => $this->documentNode ]
        );

        $this->assertStringContainsString($name, $result);
    }

    public function testStandaloneTeaserRendersSlots(): void
    {
        $article = $this->articleFactory->create([ ]);
        $result = $this->compileFusion(
            $this->siteNode,
            sprintf('Newland.Toubiz.Poi.Neos:Teaser {
                    properties = Neos.Fusion:DataStructure {
                        article = "%s"
                    }
                }', $article->getPersistenceObjectIdentifier()),
            [ 'documentNode' => $this->documentNode ]
        );

        $this->assertStringContainsString('Slot(belowTitle)', $result);
        $this->assertStringContainsString('Implement prototype(Newland.Toubiz.Poi.Neos:Slot.BelowTitle) to display', $result);
    }

}
