<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class OpeningTimesApiTest extends IntegrationTestCase
{

    public function testOpeningTimesEndpointReturnsValidJson(): void
    {
        $article = $this->articleFactory->create([
              'mainType' => ArticleConstants::TYPE_ATTRACTION,
              'openingTimes' => '{ "foo": "bar" }',
              'openingTimesFormat' => 'test',
          ]);

        $url = 'http://de.toubiz-frontend.local/' . $this->articleUrlService->openingTimesApiUrl($article, $this->node);
        $response = $this->browser->request($url);

        $this->assertEquals(200, $response->getStatusCode());
        $this->assertEquals('application/json', $response->getHeader('Content-Type'));
        $this->assertJson($response->getContent());
    }
}
