<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Faker\Factory;
use Faker\Generator;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\ContentRepository\Domain\Service\Context;
use Neos\ContentRepository\Domain\Service\NodeTypeManager;
use Neos\Flow\Http\Response;
use Neos\Flow\Http\Uri;
use Neos\Flow\Mvc\RequestInterface;
use Neos\Flow\Mvc\Routing\Router;
use Neos\Flow\Tests\FunctionalTestCase;
use Neos\Neos\Domain\Model\Site;
use Neos\Neos\Domain\Repository\SiteRepository;
use Neos\Neos\Service\LinkingService;
use Newland\NeosCommon\Service\ControllerContextFactory;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\CategoryFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\AttributeFactory;
use Psr\Http\Message\ResponseInterface;

abstract class IntegrationTestCase extends \Newland\NeosTestingHelpers\IntegrationTestCase
{
    /** @var ArticleFactory */
    protected $articleFactory;

    /** @var AttributeFactory */
    protected $attributeFactory;

    /** @var Generator */
    protected $faker;

    /** @var ArticleUrlService */
    protected $articleUrlService;

    /** @var CategoryFactory */
    protected $categoryFactory;

    public function setUp(): void
    {
        parent::setUp();
        $this->articleUrlService = $this->objectManager->get(ArticleUrlService::class);
        $this->categoryFactory = new CategoryFactory($this->objectManager);
        $this->articleFactory = new ArticleFactory($this->objectManager);
        $this->attributeFactory = new AttributeFactory($this->objectManager);
        $this->faker = Factory::create();
    }
}
