# Filtered Lists Plugin

## How filters work

### preselected topics

Prefiltered topics are a "hard" fliter.

#### preselected categories

If a category is selected here, all results that will ever
be displayed to user, even after additional filtering, will be of that category.

If more than one category is selected, all results that will ever be displayed to the user will
be of one of those categories. If "Wanderung" and "Bergtour" are selected, the user will never see
an article of category "Mountain Bike".

#### preselected attributes

If an attribute is selected, all results will have that attribute assigned. If you select "easy",
the user will only ever see "easy" items.

If more that one attribute is selected, all results will have one of those attributes assigned. If
"easy" and "medium" are selected, the user will never see "hard" items.

#### preselected categories and attributes

If categories and attributes are selected, then all items will have at least one of those categories
assigned and one of those attributes.

#### How the frontend filtering is affected

Additionally, if no further options make sense in the frontend filter sections, then that filter
section is hidden to the user. Example:
- "easy" and "medium" are preselected topics.
- "easy" and "medium" are hidden as filter options, since they should always be selected.
- Since the user will never see "hard" items, it also makes no sense to display that filter option
to the user. No filter options in the filter section "difficultyRating" are left. Thus, the entire
filter section is hidden from the user.

Another example:
- "easy" is a preselected topic.
- Following the logic above "medium" and "hard" are hidden.
- The entire filter section is hidden.

Another example:
- "Wanderung" is a preselected topic.
- "Wanderung" will be hidden as a filter option, since is should always be selected.
- In the case of tours, each item only has one category. Thus all other categories make no sense as
filters and will be hidden from that filter section.
- The filter section is now empty and the entire filter section is hidden from the user.


### topics

Topics are rendered as buttons. Functionally they behave exactly like selecting one (and only one)
filter from the filter sections and clicking "Filter".


### lists

The "lists" option only affects the swiper view. It allows to render one list for each selected
topic (as a swiper).

NOTICE: All items in each list also fulfill the requirements of the "preselected topics". If "easy"
is a preselected topic, then all items in all swipers will be "easy" items. Conflicting options may
result in empty lists: choosing "easy" as a preselected topic and then choosing "hard" as a list
will show zero results. A general use case would be to select a category as a prefiltered topic and
then group into different lists with attributes (e.g. "Wanderung" items that are "easy", "Wanderung"
items that are "wheelchairAccessible", etc.). Alternatively you could use "wheelchairAccessible" as
a prefiltered topic for a landing page, and show different swipers for different activities (all of
which will be wheelchairAccessible).


