<?php declare(strict_types=1);
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Poi\Neos\Service\LinkListService;

/**
 * The widget controller for the city list widget.
 */
class LinkListController extends AbstractWidgetController
{

    /**
     * @var LinkListService
     * @Flow\Inject()
     */
    protected $linkListService;

    public function indexAction(): void
    {
        $article = $this->widgetConfiguration['article'];
        $node = $this->widgetConfiguration['node'];

        $links = $this->linkListService->getLinks($node, $article, $this->getControllerContext());

        $this->view->assignMultiple(
            [
                'links' => $links,
                'article' => $article,
            ]
        );
    }
}
