<?php
namespace Newland\Toubiz\Poi\Neos\LinkHandler;

use Newland\NeosCommon\LinkHandler\Domain\Model\Record;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class ArticleRecord extends Record
{

    /** @var Article */
    private $article;

    /**
     * @return Article
     */
    public function getArticle(): Article
    {
        return $this->article;
    }

    public function __construct(Article $article)
    {
        $this->article = $article;
        $this->setId((string) $article->getPersistenceObjectIdentifier());
        $this->setTitle($article->getName());
    }
}
