<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Filter\Items;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query\Expr;
use Doctrine\ORM\QueryBuilder;
use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;

trait AttributeCommon
{
    /** @var EntityManagerInterface */
    protected $entityManager;
    public function injectEntityManager(EntityManagerInterface $entityManager): void
    {
        $this->entityManager = $entityManager;
    }

    protected function initializeSubQuery(string $alias): QueryBuilder
    {
        return $this->entityManager->createQueryBuilder()
            ->distinct(true)
            ->select(sprintf('IDENTITY(%s.article)', $alias))
            ->from(Attribute::class, $alias);
    }
}
