<?php

namespace Newland\Toubiz\Poi\Neos\Domain\Model;

class FilterAttribute
{

    /** @var string */
    private $value;

    /** @var string */
    private $identifier;

    /** @var string */
    private $label;

    /** @var string */
    private $group;

    /**
     * Tag constructor.
     * @param string $identifier
     * @param string $label
     * @param string $value
     */
    public function __construct(
        string $identifier,
        string $label = '',
        string $value = '',
        string $group = ''
    ) {
        $this->identifier = $identifier;
        $this->label = $label;
        $this->value = $value;
        $this->group = $group;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getGroup(): string
    {
        return $this->group;
    }
}
