<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Poi\Neos\Service;

use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class WidgetService
{
    const API_VERSION_2 = 2;
    const CATEGORY_SKI_AREA = '8a78311b-edcc-4a40-a350-96b86c202c67';

    public static function getDetailComponentName(Article $article): string
    {
        if (self::isSkiAreaData($article->getRawJson())) {
            return 'tb-w-ski-area-detail';
        }
        return 'tb-w-article-detail';
    }

    private static function isSkiAreaData(array $articleData): bool
    {
        return $articleData['apiVersion'] === self::API_VERSION_2
            && $articleData['primaryCategory']['id'] === self::CATEGORY_SKI_AREA;
    }
}
