import { listenForAddedElements } from '@nimius/dom-utility';
import { initializeVueApp } from './poi.app';
import { initializeToubizWidgetDetailPage } from './detail-page';

initializeToubizWidgetDetailPage();

function hasBeenInitializedBefore(element) {
    if (element.hasAttribute('data-vue-initialized')) {
        return true;
    }
    element.setAttribute('data-vue-initialized', 'true');
    return false;
}

listenForAddedElements(
    { selector: '[data-vue="poi"]', checkForExistingNodes: true },
    element => {
        if (!hasBeenInitializedBefore(element)) {
            initializeVueApp(element);
        }
    }
);
