import { asyncComponent, loadVue } from './vue';

export function initializeVueApp (element) {
    loadVue().then(Vue => {
        new Vue({
            el: element,
            mounted() {
                this.$el.classList.remove('hidden');
            },
            components: {
                TbOpeningTimesParser: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-basic" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-parser.vue'
                )),
                TbOpeningTimesLinePreview: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-line-preview" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-line-preview.vue'
                )),
                TbOpeningTimesExtendablePreview: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-extended" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-extendable-preview.vue'
                )),
                TbOpeningTimesSimple: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-simple" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-simple.vue'
                )),
                TbOpeningTimesSimpleLive: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-simple-live" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-simple-live.vue'
                )),
                TbOpeningTimesExtendedLinePreviewLive: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-extended-line-preview-live" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-extended-line-preview-live.vue'
                )),
            },
        });
    });
}
