<?php declare(strict_types=1);
namespace Newland\Toubiz\Poi\Neos\Filter\Items;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\NeosFiltering\Items\CheckboxList;
use Newland\Toubiz\Poi\Neos\Service\RegionService;

class RegionList extends CheckboxList
{
    /**
     * @var RegionService
     * @Flow\Inject()
     */
    protected $regionService;

    protected function getStateValuesForQuery(): array
    {
        return $this->getStateValues();
    }

    protected function getStateValues(): array
    {
        $identifiers = parent::getStateValues();

        if (empty($identifiers)) {
            return [];
        }

        return $this->regionService->collectZipsFromRegionKeys($identifiers, true);
    }
}
