<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Sitemap;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Poi\Neos\Sitemap\PoiDetailSitemapProvider;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;

class PoiDetailSitemapProviderTest extends FunctionalTestCase
{
    use InteractsWithNodes;

    protected static $testablePersistenceEnabled = true;

    /** @var PoiDetailSitemapProvider */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(PoiDetailSitemapProvider::class);
    }

    public function testProvidesLinksForArticles(): void
    {
        $site = $this->initializeSite('foo');
        $node = $this->initializeNode('/sites/foo', null, $site);

        (new ArticleFactory($this->objectManager))->createMultiple(3);
        self::assertCount(3, $this->subject->getPages($node));
    }
}
