<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Awards;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\GenericArticleAttributes;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Service\AttributeCollection;

class ContainsSingleStringViewHelper extends AbstractViewHelper
{

    public function render(Article $article): bool
    {
        foreach ($article->getFlatAttributes() as $key => $attributes) {
            /** @var AttributeCollection $attributes */
            if (strpos($key, 'houseAwards') !== 0) {
                continue;
            }

            foreach ($attributes as $attribute) {
                /** @var mixed $attribute */
                if (is_string($attribute)) {
                    return true;
                }
            }
        }

        return false;
    }
}
