<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Filter;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;

/**
 * Builds a query object for the given topic.
 * @deprecated Can be removed as soon as the Overview page node type has been removed.
 */
class QueryViewHelper extends AbstractViewHelper
{
    public function render(Topic $topic): array
    {
        switch ($topic->getType()) {
            case TopicRepository::TYPE_CATEGORY:
                $query = [ 'category' => [ $topic->getIdentifier() ] ];
                break;
            case TopicRepository::TYPE_ATTRIBUTE:
                $identifier = $topic->getIdentifier();
                if ($topic->getValue()) {
                    $identifier .= ':' . $topic->getValue();
                }
                $query = [ 'attribute' => [ $identifier ] ];
                break;
            default:
                $query = [];
                break;
        }

        return $query;
    }
}
