<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\ViewHelpers;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Poi\Neos\ViewHelpers\RatingAverageViewHelper;

class RatingAverageViewHelperTest extends FunctionalTestCase
{

    /** @var RatingAverageViewHelper */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(RatingAverageViewHelper::class);
    }

    /** @dataProvider provideRatings */
    public function testDownSamplesRatingsToFive($rating, $expected): void
    {
        $result = $this->subject->render($rating);
        $this->assertCount(5, $result);
        foreach ($expected as $key => $value) {
            $this->assertEquals($value, $result[$key]);
        }
    }

    public function provideRatings(): array
    {
        return [
            [ 99, [ 'full', 'full', 'full', 'full', 'half' ] ],
            [ 93, [ 'full', 'full', 'full', 'full', 'half' ] ],
            [ 50, [ 'full', 'full', 'half', '', '' ] ],
            [ 0, [ '', '', '', '', '' ] ],
            [ -20, [ '', '', '', '', '' ] ],
            [ 100, [ 'full', 'full', 'full', 'full', 'full' ] ],
            [ 180, [ 'full', 'full', 'full', 'full', 'full' ] ],
            [ 9, [ '', '', '', '', '' ] ],
            [ 10, [ 'half', '', '', '', '' ] ],
            [ 15, [ 'half', '', '', '', '' ] ],
            [ 19, [ 'half', '', '', '', '' ] ],
            [ 20, [ 'full', '', '', '', '' ] ],
        ];
    }
}
