<?php
namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service\Fixtures;

use Neos\Flow\Configuration\ConfigurationManager;
use Symfony\Component\Yaml\Yaml;

class MockConfigurationManager extends \Neos\Flow\Configuration\ConfigurationManager
{

    public function __construct() {
        // Nothing happens
    }

    public function getConfiguration(string $configurationType, string $configurationPath = null)
    {
        if ($configurationType === ConfigurationManager::CONFIGURATION_TYPE_SETTINGS &&
            $configurationPath === 'Newland.Toubiz.Poi.Neos.regions.available') {
            return (new Yaml())->parseFile(__DIR__ . '/Regions.yml');
        }

        if ($configurationType === ConfigurationManager::CONFIGURATION_TYPE_SETTINGS &&
            $configurationPath === 'Newland.Toubiz.Poi.Neos.regions.enabled') {
            return [];
        }

        return null;
    }
}