<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Mvc\ActionRequest;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\Toubiz\Poi\Neos\Service\ContextService;
use Neos\Flow\Annotations as Flow;

/**
 * Toubiz map node view helper.
 *
 * Returns the document/page node that contains a toubiz map.
 */
class ToubizMapNodeViewHelper extends AbstractViewHelper
{

    /**
     * @var ContextService
     * @Flow\Inject()
     */
    protected $contextService;

    /**
     * Main method.
     *
     * This may also return null in case no page contains a toubiz map.
     *
     * @return Node|null
     */
    public function render()
    {
        $site = $this->contextService->siteNodeFromControllerContext($this->controllerContext);
        $query = new FlowQuery([ $site ]);
        return $query->find('[instanceof Newland.Toubiz.Map.Neos:Map]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }
}
