<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\Toubiz\Poi\Neos\Service\ClientService;

/**
 * TPortal base URI view helper.
 *
 * Returns the configured base URI.
 */
class TportalBaseUriViewHelper extends AbstractViewHelper
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * @var ClientService
     * @Flow\Inject
     */
    protected $clientService;

    /**
     * Main method.
     *
     * @param Node $node The current node. Required to find the current site.
     * @param string $targetBaseUri Override for configured targetBaseUri.
     * @param string $targetUriSegment Override for configured targetUriSegment.
     * @return string|null
     */
    public function render(Node $node = null, $targetBaseUri = null, $targetUriSegment = null)
    {
        if ($targetBaseUri && $targetUriSegment) {
            return $this->buildUrl($targetBaseUri, $targetUriSegment);
        }

        if (!array_key_exists('lodging', $this->configuration)) {
            return null;
        }

        if ($node) {
            $currentSite = $this->currentSiteNodeName($node);
            if ($currentSite === null) {
                return null;
            }
            $targetUriSegment = $this->clientService->getCurrentLodgingClient($currentSite);
        } else {
            $targetUriSegment = $this->configuration['lodging']['targetUriSegment'];
        }

        return $this->buildUrl($this->configuration['lodging']['targetBaseUri'], $targetUriSegment);
    }

    /**
     * @return string
     */
    protected function buildUrl($base, $segment)
    {
        return $base . '/' . $segment . '/' . 'ukv';
    }

    /**
     * @param NodeInterface $node
     * @return string|null
     */
    private function currentSiteNodeName(NodeInterface $node)
    {
        $context = $node->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }

        return $context->getCurrentSite()->getNodeName();
    }
}
