<?php
namespace Newland\Toubiz\Poi\Neos\Migration\Transformations;

use Neos\ContentRepository\Domain\Model\NodeData;
use Neos\ContentRepository\Migration\Transformations\AbstractTransformation;

class PrefixCategories extends AbstractTransformation
{
    /**
     * @var string
     */
    protected $propertyName;


    /**
     * @var string
     */
    protected $topicType = '';

    /**
     * @param string $propertyName
     * @return void
     */
    public function setProperty($propertyName)
    {
        $this->propertyName = $propertyName;
    }


    /**
     *
     * @param string $topicType
     * @return void
     */
    public function setTopicType($topicType)
    {
        $this->topicType = $topicType;
    }

    /**
     * If the given node has the property this transformation should work on, this
     * returns true.
     *
     * @param NodeData $node
     * @return boolean
     */
    public function isTransformable(NodeData $node)
    {
        return ($node->hasProperty($this->propertyName));
    }

    /**
     * Change the property on the given node.
     *
     * @param NodeData $node
     * @return void
     */
    public function execute(NodeData $node)
    {
        $currentPropertyValue = $node->getProperty($this->propertyName);
        foreach ($currentPropertyValue as $i => $item) {
            if (strpos($item, $this->propertyName . ':') === false) {
                $currentPropertyValue[$i] = $this->topicType . ':' . $item;
            } else {
                $currentPropertyValue[$i] = $item;
            }
        }
        $node->setProperty($this->propertyName, $currentPropertyValue);
    }
}
