<?php
namespace Newland\Toubiz\Poi\Neos\Listener;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Poi\Neos\Service\AttributeTopicService;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Enum\ArticleType;

class BuildAttributeTopicIdentifierCache
{

    /**
     * @var AttributeTopicService
     * @Flow\Inject()
     */
    protected $attributeTopicService;

    /**
     * @param string $type
     */
    public function run(string $type)
    {
        switch ($type) {
            case ArticleType::TOURS:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_TOUR);
                break;
            case ArticleType::GASTRONOMY:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_GASTRONOMY);
                break;
            case ArticleType::DIRECT_MARKETERS:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_DIRECT_MARKETER);
                break;
            case ArticleType::LODGINGS:
            case ArticleType::POI:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_ATTRACTION);
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_LODGING);
        }
    }
}
