<?php
namespace Newland\Toubiz\Poi\Neos\Encoder;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class TopicsToQueryEncoder
{
    /**
     * @var array
     */
    private $queryOverride = [];

    /**
     * @param string[] $topicIdentifiers
     * @return array
     */
    public function encode(array $topicIdentifiers = [])
    {
        foreach ($topicIdentifiers as $topicIde) {
            $this->addQueryOverride($topicIde);
        }

        return $this->queryOverride;
    }

    protected function addQueryOverride(string $combinedIdentifier)
    {
        if (strpos($combinedIdentifier, ':') === false) {
            return;
        }

        if (preg_match(
            '/(?<type>category|attribute):(?<identifier>[a-zA-Z0-9_\-]*)(:(?<value>[a-zA-Z0-9]+))?/',
            $combinedIdentifier,
            $matches
        )
        ) {
            if ($matches['type'] === 'category') {
                if (!isset($this->queryOverride['categories'])) {
                    $this->queryOverride['categories'] = [];
                }
                $this->queryOverride['categories'][$matches['identifier']] = $matches['identifier'];
            } elseif ($matches['type'] === 'attribute' && $matches['value']) {
                if (!isset($this->queryOverride['attributes'])) {
                    $this->queryOverride['attributes'] = [];
                }

                if (!isset($this->queryOverride['attributes'][$matches['identifier']])) {
                    $this->queryOverride['attributes'][$matches['identifier']] = [ 'in' => [] ];
                }
                $this->queryOverride['attributes'][$matches['identifier']]['in'][] = $matches['value'];
            }
        }
    }
}
