<?php
namespace Newland\Toubiz\Poi\Neos\Command;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\Command\AbstractCommandController;
use Newland\Toubiz\Poi\Neos\Service\AttributeTopicService;

/**
 * @Flow\Scope("singleton")
 */
class AttributeCommandController extends AbstractCommandController
{
    /**
     * @var AttributeTopicService
     * @Flow\Inject
     */
    protected $attributeTopicService;

    /**
     * Manually rebuild the attribute cache.
     *
     * @param string $articleType
     * @param bool $quiet
     */
    public function buildCacheCommand(string $articleType, bool $quiet = false)
    {
        $this->attributeTopicService->generateAndCacheIdentifiers($articleType);
        if (!$quiet) {
            $this->output->output(' Rebuilt attribute cache for article type' . $articleType . "\r");
        }
    }
}
