import { asyncComponent, loadVue } from './vue';

export function initializeVueApp(element) {
    loadVue().then(Vue => {
        new Vue({
            el: element,
            components: {
                TbOpeningTimesParser: asyncComponent(() => import('./components/opening-times-parser.vue')),
            },
            data: { open: false },
            methods: {
                toggleOpenState() {
                    this.open = !this.open;
                },
            },
        });
    });
}