<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Poi\Neos\Service\ClientService;

/**
 * TPortal base URI view helper.
 *
 * Returns the configured base URI.
 */
class TportalBaseUriViewHelper extends AbstractViewHelper
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * @var ClientService
     * @Flow\Inject
     */
    protected $clientService;

    /**
     * Main method.
     *
     * @param Node $node The current node. Required to find the current site.
     * @return string|null
     */
    public function render(Node $node = null)
    {
        if (!array_key_exists('lodging', $this->configuration)) {
            return;
        }

        /** @deprecated: superseeded by targetBaseUri */
        if (array_key_exists('targetUri', $this->configuration['lodging'])) {
            $uri = str_replace(
                'house/:id',
                '',
                $this->configuration['lodging']['targetUri']
            );
        }

        if ($node) {
            $currentSite = $node->getContext()->getCurrentSite()->getNodeName();
            $targetUriSegment = $this->clientService->getCurrentLodgingClient($currentSite);
        } else {
            $targetUriSegment = $this->configuration['lodging']['targetUriSegment'];
        }

        return $this->configuration['lodging']['targetBaseUri'] . '/' . $targetUriSegment . '/ukv';
    }
}
