<?php
namespace Newland\Toubiz\Poi\Neos\Sitemap;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Newland\NeosCommon\Sitemap\SitemapProvider;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\Sitemap\SitemapUrl;
use Newland\NeosCommon\Service\ControllerContextFactory;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

/**
 * @Flow\Entity()
 */
class PoiDetailSitemapProvider implements SitemapProvider
{

    /**
     * @var ArticleRepository
     * @Flow\Inject
     */
    protected $articleRepository;

    /**
     * @var ArticleUrlService
     * @Flow\Inject
     */
    protected $articleUrlService;

    /**
     * @Flow\Inject
     * @var ControllerContextFactory
     */
    protected $contextFactory;

    public function getPages(NodeInterface $site): array
    {
        $pages = [];
        $context = $this->contextFactory->initializeFakeControllerContext($site);

        foreach ($this->articleRepository->findAll() as $article) {
            $url = $this->articleToSitemapUrl($article, $context);
            if ($url) {
                $pages[] = $url;
            }
        }

        return $pages;
    }

    /**
     * @param Article $article
     * @param ControllerContext $context
     * @return SitemapUrl|null
     * @throws \Neos\Eel\Exception
     * @throws \Neos\Neos\Exception
     */
    private function articleToSitemapUrl(Article $article, ControllerContext $context)
    {
        $url = $this->articleUrlService->generateUrl($article, $context);
        return $url ? new SitemapUrl($url) : null;
    }
}
