# Toubiz POI package for Neos CMS.

This package provides functionality for integrating POI from toubiz into Neos.

## Integration

### Teaser
The POI teaser is an abstract node type. This allows you to implement custom node types based on it with ease. The following example shows how to integrate a `POI Grid Teaser` node type based on the provided teaser node type from this package.

First, set up a node type configuration referencing the teaser as super type:
```
'VendorName.PackageName:PoiGridTeaser':
  superTypes:
    'Newland.Toubiz.Poi.Neos:Teaser': true

  ui:
    label: 'POI Grid Teaser'
```

As the teaser is a plugin, you need a fusion prototype for your plugin referencing the teaser fusion prototype:
```
prototype(Newland.AutTheme:PoiGridTeaser) >
prototype(Newland.AutTheme:PoiGridTeaser) < prototype(Newland.Toubiz.Poi.Neos:Teaser)
```

Most likely, you want to adapt the rendering to e.g. wrap the teaser output with additional markup. For this, you need to add a few bits of fusion script:
```
prototype(Newland.AutTheme:PoiGridTeaser) < prototype(Newland.Toubiz.Poi.Neos:Teaser) {
  wrapStart = '<div class="o-grid__item">'
  wrapEnd = '</div>'
}
```

If you extend your node type with properties, you can access them as usual inside the fusion script. The following would also be possible:
```
wrapStart = ${'<div class="o-grid__item ' + q(node).property('distribution') + '">'}
```

### List
Links to article detail pages can be rendered using the LinkViewHelper.

This will automatically find the first available list/detail plugin to display the article.

Notice: Plugins with the setting "Use this page as detail view for articles of this type." will be preferred.
