<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Domain\Repository;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\AttributeFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\CategoryFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventFactory;

class TopicRepositoryTest extends FunctionalTestCase
{

    protected static $testablePersistenceEnabled = true;

    /** @var TopicRepository */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(TopicRepository::class);
    }

    public function testFindsAllTopicsForCategoriesInGivenLanguage(): void
    {
        $factory = new CategoryFactory($this->objectManager);
        $german = $factory->create([ 'language' => 'de' ]);
        $english = $factory->create([ 'language' => 'en' ]);

        $this->subject->setLanguage('de');
        $tags = $this->subject->findAllCategory();
        $ids = array_map(
            function(Topic $topic) {
                return $topic->getCombinedIdentifier();
            },
            $tags
        );

        $this->assertContains('category:' . $german->getPersistenceObjectIdentifier(), $ids);
        $this->assertNotContains('category:' . $english->getPersistenceObjectIdentifier(), $ids);
    }

    public function testSettingLanguageDoesNotTaintRepository(): void
    {
        $categoryRepository = $this->objectManager->get(CategoryRepository::class);
        $categoryRepository->setLanguage('de');

        $this->subject->setLanguage('en');
        $this->subject->findAll();

        $this->assertEquals('de', $categoryRepository->getLanguage());
    }
}
