<?php
namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\I18n\Locale;
use Neos\Flow\I18n\Translator;
use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Poi\Neos\Service\AttributeTopicService;

class AttributeTopicServiceTest extends UnitTestCase
{
    /**
     * @var AttributeTopicService
     */
    protected $subject;

    protected static $config = [
        'package' => null,
        'source' => null,
    ];

    public function setUp()
    {
        $this->subject = new AttributeTopicService();

        $translator = $this->createMock(Translator::class);
        $translator->method('translateById')->willReturnCallback(
            function ($id, $arguments, $quantity, Locale $locale, $source, $package) {
                if ($id === 'englishOnly') {
                    if ($locale->getLanguage() === 'en') {
                        return 'English Only Value';
                    }

                    return null;
                }

                if ($id === 'untranslated') {
                    return null;
                }

                return null;
            }
        );
        $this->inject($this->subject, 'translator', $translator);
    }

    public function testDisplayFallbackTranslationIfActualTranslationIsNotAvailable(): void
    {
        $this->assertEquals(
            'English Only Value',
            $this->subject->getTranslationWithLanguageFallback(self::$config, 'englishOnly', new Locale('de'))
        );
    }

    public function testDisplayIdIfNoTranslationIsNotAvailable(): void
    {
        $this->assertEquals(
            'untranslated',
            $this->subject->getTranslationWithLanguageFallback(self::$config, 'untranslated', new Locale('de'))
        );
    }
}
