<?php
namespace Newland\Toubiz\Poi\Neos\DataSource;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Poi\Neos\Service\RegionService;

/**
 * @Flow\Scope("singleton")
 */
class RegionsDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-poi-neos-regions';

    /**
     * @var RegionService
     * @Flow\Inject()
     */
    protected $regionService;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        if ($node === null) {
            return [];
        }

        $regions = [];
        foreach ($this->regionService->getAllEnabled($node) as $key => $region) {
            $regions[] = [ 'label' => $region['name'], 'value' => $key ];
        }

        return $regions;
    }
}
