<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AwardRepository;

class AwardDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-poi-neos-awards';

    /**
     * @var AwardRepository
     * @Flow\Inject()
     */
    protected $awardRepository;

    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        return $this->awardRepository->findAllForDataSource();
    }
}
