<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Overview;

use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

abstract class OverviewTestCase extends IntegrationTestCase
{

    protected abstract function articleType(): int;

    protected function article(array $attributes = []): Article
    {
        $attributes['mainType'] = $this->articleType();

        return $this->articleFactory->create($attributes);
    }

    public function testListsContainArticlesAccordingToSelectedCategory(): void
    {
        [ $cat1, $cat2 ] = $this->categoryFactory->createMultiple(2);
        $this->article([ 'name' => 'RELATED_TO_FIRST', 'categories' => [ $cat1 ] ]);
        $this->article([ 'name' => 'RELATED_TO_SECOND', 'categories' => [ $cat2 ] ]);
        $this->article([ 'name' => 'RELATED_TO_BOTH', 'categories' => [ $cat1, $cat2 ] ]);
        $this->article([ 'name' => 'RELATED_TO_NONE','categories' => [ ] ]);


        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Poi.Neos:FilteredLists'));
        $this->node->setProperty('articleType', $this->articleType());
        $this->node->setProperty('lists', [ 'category:' . $cat1->getPersistenceObjectIdentifier() ]);
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);

        $this->assertResponseContains('RELATED_TO_FIRST', $response, 'Should display article related to first category');
        $this->assertResponseNotContains('RELATED_TO_SECOND', $response, 'Should not display article related to second category');
        $this->assertResponseContains('RELATED_TO_BOTH', $response, 'Should display article related to both categories');
        $this->assertResponseNotContains('RELATED_TO_NONE', $response, 'Should not display article related to no category');
    }

    public function testContainsNumberOfTotalResults()
    {
        [ $cat1, $cat2 ] = $this->categoryFactory->createMultiple(2);
        $num = random_int(20, 40);
        $this->articleFactory->createMultiple($num, [ 'categories' => [ $cat1 ] ]);
        $this->articleFactory->createMultiple($num + 1, [ 'categories' => [ $cat2 ] ]);

        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Poi.Neos:FilteredLists'));
        $this->node->setProperty('articleType', $this->articleType());
        $this->node->setProperty('lists', [ 'category:' . $cat1->getPersistenceObjectIdentifier() ]);
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);

        $this->assertResponseContains(sprintf('(%d)', $num), $response);
    }
}
