<?php declare(strict_types=1);
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\OpeningTimes;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Poi\Neos\OpeningTimes\Parser\KitchenTimes\LegacyFormatParser;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class KitchenTimesViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function render(string $openingTimes, string $as, string $openingTimesFormat = 'legacy'): string
    {
        $templateVariableContainer = $this->renderingContext->getVariableProvider();

        switch ($openingTimesFormat) {
            case 'legacy':
                $parser = new LegacyFormatParser();
                break;
            default:
                throw new \Exception(
                    sprintf('No parser found for opening times format "%s".', $openingTimesFormat)
                );
        }

        $parsedOpeningTimes = $parser->parse($openingTimes);
        $templateVariableContainer->add($as, $parsedOpeningTimes);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($as);

        return $output;
    }
}
