<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Teaser;

use Neos\Neos\Domain\Service\FusionService;
use Newland\NeosTestingHelpers\CompilesFusion;
use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Tests\Factory\StarClassificationFactory;

abstract class TeaserTestCase extends IntegrationTestCase
{
    protected abstract function articleType(): int;

    /** @var StarClassificationFactory */
    protected $starClassificationFactory;

    public function setUp(): void
    {
        parent::setUp();
        $this->starClassificationFactory = new StarClassificationFactory($this->objectManager);
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Poi.Neos:Teaser'));
        $this->persistNode($this->node);
    }

    protected function article(array $attributes = []): Article
    {
        $attributes['mainType'] = $this->articleType();
        return $this->articleFactory->create($attributes);
    }

    public function testRendersSlots(): void
    {
        $article = $this->article();
        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri());
        $this->assertResponseOk($response);

        foreach ($this->provideSlotsThatShouldExist() as [ $slot ]) {
            $this->assertResponseContains(sprintf('Slot(%s)', $slot), $response, null, false);
        }
    }

    public function provideSlotsThatShouldExist(): array
    {
        return [
            [ 'aboveAll' ],
            [ 'belowAll' ],
            [ 'aboveTeaser' ],
            [ 'belowTeaser' ],
            [ 'aboveStandaloneTeaser' ],
            [ 'belowStandaloneTeaser' ],
            [ 'aboveTitle' ],
            [ 'belowTitle' ],
            [ 'aboveTeaserTitle' ],
            [ 'belowTeaserTitle' ],
            [ 'aboveImage' ],
            [ 'belowImage' ],
            [ 'aboveTeaserImage' ],
            [ 'belowTeaserImage' ],
        ];
    }
}
