<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

/**
 * TPortal base URI view helper.
 *
 * Returns the configured base URI.
 */
class TportalBaseUriViewHelper extends AbstractViewHelper
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Main method.
     *
     * @return string|null
     */
    public function render()
    {
        if (array_key_exists('lodging', $this->configuration)) {
            $uri = str_replace(
                'house/:id',
                '',
                $this->configuration['lodging']['targetUri']
            );
        } else {
            $uri = null;
        }

        return $uri;
    }
}
