<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class SitemapTest extends IntegrationTestCase
{

    /** @dataProvider provideArticleMainTypes */
    public function testAddsArticlesToSitemap(int $mainType): void
    {
        $article = $this->articleFactory->create([ 'mainType' => $mainType ]);
        $articleUri = $this->articleUrlService->generateUrlByCurrentNode($article, $this->node);

        $response = $this->browser->request($this->nodeUri->withPath('/sitemap.xml'));
        $this->assertResponseOk($response);
        $this->assertResponseContains($articleUri, $response, null, false);
    }

    public function testSitemapStillContainsDocumentNodes(): void
    {
        $response = $this->browser->request($this->nodeUri->withPath('/sitemap.xml'));
        $this->assertResponseOk($response);
        $this->assertResponseContains((string) $this->nodeUri, $response, null, false);
    }

    public function provideArticleMainTypes(): array
    {
        return array_map(
            function($mainType) {
                return [ $mainType ];
            },
            ArticleConstants::ALL_TYPES
        );
    }

}
