<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Controller;

use Newland\NeosCommon\Controller\AbstractApiController;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use function Safe\json_decode;
use function Safe\json_encode;

class ApiController extends AbstractApiController
{
    public function openingTimesAction(Article $article): string
    {
        $openingTimes = $article->getOpeningTimes();
        $unserialized = $openingTimes ? json_decode($openingTimes) : null;
        return json_encode([
             'format' => $article->getOpeningTimesFormat(),
             'definitions' => $unserialized,
        ]);
    }
}
