<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Detail;

use Newland\Toubiz\Api\ObjectAdapter\Attributes\PointOfInterestAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class AttractionDetailTest extends AbstractDetailTestCase
{
    protected function articleType(): int
    {
        return ArticleConstants::TYPE_ATTRACTION;
    }

    /** @dataProvider provideAttributeValues */
    public function testContainsAttributeValue(string $attributeName, string $attributeValue = null): void
    {
        $attributeValue = $attributeValue ?? $this->faker->words(10, true);
        $article = $this->article([
            'attributes' => [
                $this->attributeFactory->create([ 'name' => $attributeName, 'data' => $attributeValue ]),
            ],
        ]);

        $response = $this->requestArticleDetailPage($article);
        $this->assertResponseOk($response);
        $this->assertResponseContains($attributeValue, $response);
    }

    public function provideAttributeValues(): array
    {
        return [
            // Features
            [ PointOfInterestAttributes::INFORMATION ],
            [ PointOfInterestAttributes::ACCEPTED_PAYMENTS ],
            [ PointOfInterestAttributes::FOR_KIDS ],
            [ PointOfInterestAttributes::SPOKEN_LANGUAGES ],
            [ PointOfInterestAttributes::PRICE_SEGMENT ],
        ];
    }
}
