<?php

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\ViewHelpers\Widget\Controller\Mock;

use Neos\Flow\Mvc\Controller\ControllerContext;
use Neos\Flow\Mvc\View\ViewInterface;

class MockView implements ViewInterface
{
    /** @var ControllerContext */
    public $controllerContext;

    public $assignments = [];

    public $renderedView = '';

    public function setControllerContext(ControllerContext $controllerContext)
    {
        $this->controllerContext = $controllerContext;
    }

    public function assign($key, $value)
    {
        $this->assignments[$key] = $value;
    }

    public function assignMultiple(array $values)
    {
        foreach ($values as $key => $value) {
            $this->assign($key, $value);
        }
    }

    public function canRender(ControllerContext $controllerContext)
    {
        return true;
    }

    public function render()
    {
        return $this->renderedView;
    }

    public static function createWithOptions(array $options)
    {
        return new static();
    }
}