<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;

class ArticleUrlServiceTest extends FunctionalTestCase
{
    use InteractsWithNodes;
    protected static $testablePersistenceEnabled = true;

    /** @var ArticleUrlService */
    protected $subject;

    /** @var ArticleFactory */
    protected $factory;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new ArticleFactory($this->objectManager);
        $this->subject = $this->objectManager->get(ArticleUrlService::class);
    }

    public function testBuildsUrlToOpeningTimesEndpoint(): void
    {
        $article = $this->factory->create([
            'mainType' => ArticleConstants::TYPE_ATTRACTION,
            'openingTimes' => '{ "foo": "bar" }',
            'openingTimesFormat' => 'test',
        ]);

        $url = $this->subject->openingTimesApiUrl($article, $this->initializeNode('/sites/foo'));

        // Development URLs that don't work in production.
        $this->assertStringNotContainsString('newland.toubiz.poi.neos', $url);

        $this->assertStringContainsString(
            sprintf('toubiz-poi/%s/opening-times', $article->getPersistenceObjectIdentifier()),
            $url
        );
    }
}
