<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Lists;

use Newland\Toubiz\Api\ObjectAdapter\Attributes\GastronomyAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class GastronomyListTest extends AbstractListTestCase
{
    protected function articleType(): int
    {
        return ArticleConstants::TYPE_GASTRONOMY;
    }

    public function testCanBeFilteredForAwards(): void
    {
        $this->gastronomyWithDecorations('__WITH_DEHOGA__', [ GastronomyAttributes::HOUSE_DECORATION_DEHOGA ]);
        $this->gastronomyWithDecorations('__WITH_MICHELIN__', [ GastronomyAttributes::HOUSE_DECORATION_MICHELIN ]);
        $this->gastronomyWithDecorations('__WITH_BOTH__', [ GastronomyAttributes::HOUSE_DECORATION_DEHOGA, GastronomyAttributes::HOUSE_DECORATION_MICHELIN ]);
        $this->gastronomyWithDecorations('__WITH_NONE__', [ ]);

        // Without any filters: All should be displayed
        $response = $this->browser->request($this->nodeUri());
        $this->assertResponseOk($response);
        $this->assertResponseContains('__WITH_DEHOGA__', $response);
        $this->assertResponseContains('__WITH_MICHELIN__', $response);
        $this->assertResponseContains('__WITH_BOTH__', $response);
        $this->assertResponseContains('__WITH_NONE__', $response);

        // With award filter: Only those with awards should be displayed
        $response = $this->browser->request($this->nodeUri([ 'excelentCuisine[0]' => 'houseAwards' ]));
        $this->assertResponseOk($response);
        $this->assertResponseContains('__WITH_DEHOGA__', $response);
        $this->assertResponseContains('__WITH_MICHELIN__', $response);
        $this->assertResponseContains('__WITH_BOTH__', $response);
        $this->assertResponseNotContains('__WITH_NONE__', $response);
    }

    private function gastronomyWithDecorations(string $name, array $decorations): Article
    {
        $attributes = array_map(
            function(string $decoration) {
                return $this->attributeFactory->make([ 'name' => $decoration, 'value' => $decoration ]);
            },
            $decorations
        );
        return $this->articleFactory->create([
             'mainType' => ArticleConstants::TYPE_GASTRONOMY,
             'name' => $name,
             'attributes' => $attributes,
        ]);
    }
}
