import { asyncComponent, loadVue } from './vue';

export function initializeVueApp (element) {
    loadVue().then(Vue => {
        new Vue({
            el: element,
            mounted() {
                this.$el.style.display = '';
            },
            components: {
                TbOpeningTimesLinePreview: asyncComponent(
                    () => import('@newland/assets-neos/Scripts/opening-times/opening-times-line-preview.vue')
                ),
                TbOpeningTimesTable: asyncComponent(
                    () => import('@newland/assets-neos/Scripts/opening-times/opening-times-table.vue')
                ),
                TbOpeningTimesDatePicker: asyncComponent(
                    () => import('@newland/assets-neos/Scripts/opening-times/opening-times-date-picker.vue')
                ),
            },
        });
    });
}
