<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Detail;

use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class TourDetailTest extends AbstractDetailTestCase
{
    protected function articleType(): int
    {
        return ArticleConstants::TYPE_TOUR;
    }

    public function testRendersOutdoorActiveMapForOutdoorActiveTours(): void
    {
        $article = $this->article([
            'longitude' => 20,
            'latitude' => 20,
            'attributes' => [
                $this->attributeFactory->make([
                    'name' => TourAttributes::DATA_SOURCE,
                    'data' => TourAttributes::DATA_SOURCE_OUTDOOR_ACTIVE
                ])
            ]
        ]);

        $response = $this->browser->request($this->articleUrl($article));
        $this->assertResponseOk($response);
        $this->assertResponseContains('data-oa-map', $response);
    }
    public function testDoesNotRenderOutdoorActiveMapForNonOutdoorActiveTours(): void
    {
        $article = $this->article([
            'longitude' => 20,
            'latitude' => 20,
            'attributes' => [
                $this->attributeFactory->make([
                    'name' => TourAttributes::DATA_SOURCE,
                    'data' => TourAttributes::DATA_SOURCE_TOUBIZ_LEGACY
                ])
            ]
        ]);

        $response = $this->browser->request($this->articleUrl($article));
        $this->assertResponseOk($response);
        $this->assertResponseNotContains('data-oa-map', $response);
    }

    public function testOutdoorActiveToursDisplayDetailLinkIfRegioClientConfigured(): void
    {
        $article = $this->article([
            'longitude' => 20,
            'latitude' => 20,
            'attributes' => [
                $this->attributeFactory->make([
                    'name' => TourAttributes::DATA_SOURCE,
                    'data' => TourAttributes::DATA_SOURCE_OUTDOOR_ACTIVE
                ]),
                $this->attributeFactory->make([
                    'name' => TourAttributes::DATA_SOURCE_ID,
                    'data' => '123456'
                ])
            ]
        ]);

        $configPath = sprintf('Newland.Toubiz.Poi.Neos.outdoorActiveConfigurations.sites.%s', $this->site->getNodeName());
        $this->withMockedConfiguration([
            $configPath => [
                'apiKey' => 'FOO',
                'client' => 'FOO',
                'regioClient' => 'FOO',
            ]
        ], function() use ($article) {
            $response = $this->browser->request($this->articleUrl($article));
            $this->assertResponseOk($response);
            $this->assertResponseContains('regio.outdooractive.com', $response);
        });
    }


    public function testOutdoorActiveToursDontDisplayDetailLinkIfRegioClientNotConfigured(): void
    {
        $article = $this->article([
            'longitude' => 20,
            'latitude' => 20,
            'attributes' => [
                $this->attributeFactory->make([
                    'name' => TourAttributes::DATA_SOURCE,
                    'data' => TourAttributes::DATA_SOURCE_OUTDOOR_ACTIVE
                ]),
                $this->attributeFactory->make([
                    'name' => TourAttributes::DATA_SOURCE_ID,
                    'data' => '123456'
                ])
            ]
        ]);

        $configPath = sprintf('Newland.Toubiz.Poi.Neos.outdoorActiveConfigurations.sites.%s', $this->site->getNodeName());
        $this->withMockedConfiguration([
            $configPath => [
                'apiKey' => 'FOO',
                'client' => 'FOO',
            ]
        ], function() use ($article) {
            $response = $this->browser->request($this->articleUrl($article));
            $this->assertResponseOk($response);
            $this->assertResponseNotContains('regio.outdooractive.com', $response);
        });
    }
}
